/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class DataHolder {
    public static final DataHolder EMPTY = new Empty();
    private final class_1297 entity;
    private Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
    private boolean pendingSync;

    public DataHolder(class_1297 entity) {
        this.entity = entity;
    }

    <E extends class_1297, T> boolean set(SyncedDataKey<?, ?> key, T value) {
        DataEntry entry = this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2));
        if (!entry.getValue().equals(value)) {
            entry.setValue(value);
            return true;
        }
        return false;
    }

    @Nullable
    <E extends class_1297, T> T get(SyncedDataKey<E, T> key) {
        return this.dataMap.computeIfAbsent(key, key2 -> new DataEntry(this, key2)).getValue();
    }

    boolean markForSync() {
        if (SyncedEntityData.instance().markForSync(this.entity)) {
            this.pendingSync = true;
            return true;
        }
        return false;
    }

    boolean isPendingSync() {
        return this.pendingSync;
    }

    void clearSync() {
        this.pendingSync = false;
        this.dataMap.forEach((key, entry) -> entry.clearSync());
    }

    List<DataEntry<?, ?>> gatherPendingSyncDataEntries() {
        return this.dataMap.values().stream().filter(DataEntry::isPendingSync).filter(entry -> entry.getKey().syncMode().willSync()).collect(Collectors.toList());
    }

    List<DataEntry<?, ?>> gatherAllTrackingDataEntries() {
        return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode().willSync()).collect(Collectors.toList());
    }

    public boolean serialize(class_11372 output) {
        class_11372.class_11374 list = output.method_71476("Entries");
        this.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                class_11372 entryOutput = list.method_71480();
                entryOutput.method_71469("ClassKey", key.classKey().id().toString());
                entryOutput.method_71469("DataKey", key.id().toString());
                entry.write(entryOutput);
            }
        });
        return true;
    }

    public void deserialize(class_11368 input) {
        this.dataMap.clear();
        class_11368.class_11370 list = input.method_71438("Entries");
        list.forEach(entryInput -> {
            Optional rawClassKey = entryInput.method_71441("ClassKey");
            if (rawClassKey.isEmpty()) {
                return;
            }
            Optional rawDataKey = entryInput.method_71441("DataKey");
            if (rawDataKey.isEmpty()) {
                return;
            }
            class_2960 classKey = class_2960.method_12829((String)((String)rawClassKey.get()));
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            Map<class_2960, SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getDataKeys(syncedClassKey);
            if (keys == null) {
                return;
            }
            class_2960 dataKey = class_2960.method_12829((String)((String)rawDataKey.get()));
            SyncedDataKey<?, ?> syncedDataKey = keys.get(dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(this, syncedDataKey);
            entry.read((class_11368)entryInput);
            this.dataMap.put(syncedDataKey, entry);
        });
    }

    public void copyInto(DataHolder other, class_7225.class_7874 provider, boolean copyAllKeys) {
        try (class_8942.class_11340 collector = new class_8942.class_11340(this.entity.method_71370(), Constants.LOG);){
            HashMap newDataMap = new HashMap();
            this.dataMap.forEach((key, entry) -> {
                if (copyAllKeys || key.persistent()) {
                    DataEntry newEntry = new DataEntry(other, key);
                    class_11362 output = class_11362.method_71459((class_8942)collector, (class_7225.class_7874)provider);
                    entry.write((class_11372)output);
                    class_11368 input = class_11352.method_71417((class_8942)collector, (class_7225.class_7874)provider, (class_2487)output.method_71475());
                    newEntry.read(input);
                    newDataMap.put((SyncedDataKey<?, ?>)key, newEntry);
                }
            });
            other.dataMap = newDataMap;
        }
    }

    private static class Empty
    extends DataHolder {
        public Empty() {
            super(null);
        }

        @Override
        <E extends class_1297, T> boolean set(SyncedDataKey<?, ?> key, T value) {
            return false;
        }

        @Override
        @Nullable
        <E extends class_1297, T> T get(SyncedDataKey<E, T> key) {
            return null;
        }

        @Override
        boolean markForSync() {
            return false;
        }

        @Override
        boolean isPendingSync() {
            return false;
        }

        @Override
        void clearSync() {
        }

        @Override
        List<DataEntry<?, ?>> gatherAllTrackingDataEntries() {
            return Collections.emptyList();
        }

        @Override
        List<DataEntry<?, ?>> gatherPendingSyncDataEntries() {
            return Collections.emptyList();
        }

        @Override
        public boolean serialize(class_11372 output) {
            return false;
        }

        @Override
        public void deserialize(class_11368 input) {
        }

        @Override
        public void copyInto(DataHolder other, class_7225.class_7874 provider, boolean copyAllKeys) {
        }
    }
}

