/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.event;

import com.mrcrayfish.framework.api.event.FrameworkEvent;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public final class FrameworkPlayerEvents {
    public static final FrameworkEvent<StartedTrackingEntity> STARTED_TRACKING_ENTITY = new FrameworkEvent<StartedTrackingEntity>(listeners -> (entity, player) -> listeners.forEach(event -> event.handle(entity, player)));
    public static final FrameworkEvent<StoppedTrackingEntity> STOPPED_TRACKING_ENTITY = new FrameworkEvent<StoppedTrackingEntity>(listeners -> (entity, player) -> listeners.forEach(event -> event.handle(entity, player)));
    public static final FrameworkEvent<Copy> COPY = new FrameworkEvent<Copy>(listeners -> (oldPlayer, newPlayer, conqueredEnd) -> listeners.forEach(event -> event.handle(oldPlayer, newPlayer, conqueredEnd)));
    public static final FrameworkEvent<ChangeDimension> CHANGE_DIMENSION = new FrameworkEvent<ChangeDimension>(listeners -> (player, oldDimension, newDimension) -> listeners.forEach(event -> event.handle(player, (class_5321<class_1937>)oldDimension, (class_5321<class_1937>)newDimension)));
    public static final FrameworkEvent<Respawn> RESPAWN = new FrameworkEvent<Respawn>(listeners -> (player, finishedGame) -> listeners.forEach(event -> event.handle(player, finishedGame)));
    public static final FrameworkEvent<LoggedIn> LOGGED_IN = new FrameworkEvent<LoggedIn>(listeners -> player -> listeners.forEach(event -> event.handle(player)));
    public static final FrameworkEvent<LoggedOut> LOGGED_OUT = new FrameworkEvent<LoggedOut>(listeners -> player -> listeners.forEach(event -> event.handle(player)));
    public static final FrameworkEvent<PickupItem> PICKUP_ITEM = new FrameworkEvent<PickupItem>(listeners -> (player, itemEntity) -> {
        for (PickupItem listener : listeners) {
            if (!listener.handle(player, itemEntity)) continue;
            return true;
        }
        return false;
    });
    public static final FrameworkEvent<CraftedItem> CRAFTED_ITEM = new FrameworkEvent<CraftedItem>(listeners -> (player, stack, container) -> listeners.forEach(event -> event.handle(player, stack, container)));
    public static final FrameworkEvent<PickupExperience> PICKUP_EXPERIENCE = new FrameworkEvent<PickupExperience>(listeners -> (player, experienceOrb) -> {
        for (PickupExperience listener : listeners) {
            if (!listener.handle(player, experienceOrb)) continue;
            return true;
        }
        return false;
    });
    public static final FrameworkEvent<Death> DEATH = new FrameworkEvent<Death>(listeners -> (player, damageSource) -> {
        for (Death listener : listeners) {
            if (!listener.handle(player, damageSource)) continue;
            return true;
        }
        return false;
    });

    @FunctionalInterface
    public static interface Death {
        public boolean handle(class_1657 var1, class_1282 var2);
    }

    @FunctionalInterface
    public static interface PickupExperience {
        public boolean handle(class_1657 var1, class_1303 var2);
    }

    @FunctionalInterface
    public static interface CraftedItem {
        public void handle(class_1657 var1, class_1799 var2, class_1263 var3);
    }

    @FunctionalInterface
    public static interface PickupItem {
        public boolean handle(class_1657 var1, class_1542 var2);
    }

    @FunctionalInterface
    public static interface LoggedOut {
        public void handle(class_1657 var1);
    }

    @FunctionalInterface
    public static interface LoggedIn {
        public void handle(class_1657 var1);
    }

    @FunctionalInterface
    public static interface Respawn {
        public void handle(class_1657 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ChangeDimension {
        public void handle(class_1657 var1, class_5321<class_1937> var2, class_5321<class_1937> var3);
    }

    @FunctionalInterface
    public static interface Copy {
        public void handle(class_1657 var1, class_1657 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface StoppedTrackingEntity {
        public void handle(class_1297 var1, class_1657 var2);
    }

    @FunctionalInterface
    public static interface StartedTrackingEntity {
        public void handle(class_1297 var1, class_1657 var2);
    }
}

