/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config;

import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.config.AbstractProperty;
import com.mrcrayfish.framework.api.config.validate.Validator;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class ListProperty<T>
extends AbstractProperty<List<T>> {
    public static final Type<Boolean> BOOL = new Type<Boolean>(class_9135.field_48547, Boolean.class, new Class[0]);
    public static final Type<Double> DOUBLE = new Type<Double>(class_9135.field_48553, Double.class, new Class[0]);
    public static final Type<Integer> INT = new Type<Integer>(class_9135.field_49675, Integer.class, new Class[0]);
    public static final Type<Long> LONG = new Type<Long>(class_9135.field_48551, Long.class, Integer.class);
    public static final Type<String> STRING = new Type<String>(class_9135.field_48554, String.class, new Class[0]);
    private final Supplier<List<T>> defaultList;
    private final Type<T> type;
    private final Validator<T> elementValidator;

    ListProperty(Supplier<List<T>> defaultList, Type<T> type, Validator<T> elementValidator) {
        super(null, (UnmodifiableConfig config, List<String> path) -> (List)config.getOrElse(path, (Object)((List)defaultList.get())));
        this.defaultList = defaultList;
        this.type = type;
        this.elementValidator = elementValidator;
    }

    public Type<T> getType() {
        return this.type;
    }

    @Override
    public class_9139<? super class_2540, List<T>> streamCodec() {
        return this.type.streamCodec.method_56433(class_9135.method_56363());
    }

    @Override
    public List<T> getDefaultValue() {
        return this.defaultList.get();
    }

    @Override
    public boolean isDefault() {
        return ListProperty.compareLists((List)this.get(), this.getDefaultValue(), this.getType());
    }

    @Override
    public void defineSpec(ConfigSpec spec) {
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Config property is not initialized yet");
        spec.defineList(this.data.getPath(), this.defaultList::get, e -> {
            if (this.type == LONG && this.type.test(e)) {
                e = ((Number)e).longValue();
            }
            return e != null && this.type.test(e) && (this.elementValidator == null || this.elementValidator.test(e));
        });
    }

    @Override
    public boolean isValid(List<T> value) {
        return value != null && value.stream().allMatch(e -> e != null && this.type.test(e) && (this.elementValidator == null || this.elementValidator.test(e)));
    }

    public static <T> ListProperty<T> create(Type<T> type) {
        return ListProperty.create(type, ArrayList::new);
    }

    public static <T> ListProperty<T> create(Type<T> type, Supplier<List<T>> defaultList) {
        return ListProperty.create(type, null, defaultList);
    }

    public static <T> ListProperty<T> create(Type<T> type, Validator<T> elementValidator) {
        return ListProperty.create(type, elementValidator, ArrayList::new);
    }

    public static <T> ListProperty<T> create(Type<T> type, Validator<T> elementValidator, Supplier<List<T>> defaultList) {
        return new ListProperty<T>(defaultList, type, elementValidator);
    }

    public static <T> boolean compareLists(List<T> a, List<T> b, Type<T> type) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (type == LONG) {
                long v1 = ((Number)a.get(i)).longValue();
                long v2 = ((Number)b.get(i)).longValue();
                if (Objects.equals(v1, v2)) continue;
                return false;
            }
            if (Objects.equals(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public static final class Type<T> {
        private final class_9139<ByteBuf, T> streamCodec;
        private final Class<T> classType;
        private final Class<?>[] additionalTypes;

        private Type(class_9139<ByteBuf, T> streamCodec, Class<T> classType, Class<?> ... additionalTypes) {
            this.streamCodec = streamCodec;
            this.classType = classType;
            this.additionalTypes = additionalTypes;
        }

        private boolean test(Object o) {
            Preconditions.checkNotNull((Object)o);
            for (Class<?> validType : this.additionalTypes) {
                if (validType != o.getClass()) continue;
                return true;
            }
            return this.classType == o.getClass();
        }
    }
}

