/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget.element;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_3414;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public abstract class Sound {
    public static final float DEFAULT_UI_VOLUME = 0.25f;
    public static final float DEFAULT_UI_PITCH = 1.0f;

    public abstract class_3414 value();

    public abstract float volume();

    public abstract float pitch();

    public static Sound create(class_6880<class_3414> holder) {
        return new Impl(() -> holder.comp_349(), rand -> Float.valueOf(0.25f), rand -> Float.valueOf(1.0f));
    }

    public static Sound create(class_6880<class_3414> holder, float volume, float pitch) {
        return new Impl(() -> holder.comp_349(), rand -> Float.valueOf(volume), rand -> Float.valueOf(pitch));
    }

    public static Sound create(class_6880<class_3414> holder, Function<class_5819, Float> volumeFunction, Function<class_5819, Float> pitchFunction) {
        return new Impl(() -> holder.comp_349(), volumeFunction, pitchFunction);
    }

    public static Sound create(class_3414 event) {
        return new Impl(() -> event, rand -> Float.valueOf(0.25f), rand -> Float.valueOf(1.0f));
    }

    public static Sound create(class_3414 event, float volume, float pitch) {
        return new Impl(() -> event, rand -> Float.valueOf(volume), rand -> Float.valueOf(pitch));
    }

    public static Sound create(class_3414 event, Function<class_5819, Float> volumeFunction, Function<class_5819, Float> pitchFunction) {
        return new Impl(() -> event, volumeFunction, pitchFunction);
    }

    public static Sound create(Supplier<class_3414> sound) {
        return new Impl(sound, rand -> Float.valueOf(0.25f), rand -> Float.valueOf(1.0f));
    }

    public static Sound create(Supplier<class_3414> sound, float volume, float pitch) {
        return new Impl(sound, rand -> Float.valueOf(volume), rand -> Float.valueOf(pitch));
    }

    public static Sound create(Supplier<class_3414> sound, Function<class_5819, Float> volumeFunction, Function<class_5819, Float> pitchFunction) {
        return new Impl(sound, volumeFunction, pitchFunction);
    }

    private static class Impl
    extends Sound {
        private static final class_5819 RANDOM = class_5819.method_43047();
        private final Supplier<class_3414> soundSupplier;
        private final Function<class_5819, Float> volumeFunction;
        private final Function<class_5819, Float> pitchFunction;

        private Impl(Supplier<class_3414> soundSupplier, Function<class_5819, Float> volumeFunction, Function<class_5819, Float> pitchFunction) {
            this.soundSupplier = soundSupplier;
            this.volumeFunction = volumeFunction;
            this.pitchFunction = pitchFunction;
        }

        @Override
        public class_3414 value() {
            return this.soundSupplier.get();
        }

        @Override
        public float volume() {
            return this.volumeFunction.apply(RANDOM).floatValue();
        }

        @Override
        public float pitch() {
            return this.pitchFunction.apply(RANDOM).floatValue();
        }
    }
}

