/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Border;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Padding;
import com.mrcrayfish.framework.client.ClientUtils;
import com.mrcrayfish.framework.platform.ClientServices;
import com.mrcrayfish.framework.util.Utils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class FrameworkSelectionList
extends class_4280<Item> {
    public static final class_2960 DEFAULT_BACKGROUND = Utils.rl("widget/selection_list/background");
    public static final ItemSprites DEFAULT_ITEM_SPRITE = ItemSprites.builder().setEnabledSelected(Utils.rl("widget/selection_list/item_enabled_selected")).setEnabledHoveredSelected(Utils.rl("widget/selection_list/item_enabled_selected")).build();
    public static final Padding DEFAULT_LIST_PADDING = Padding.of(4);
    public static final Border DEFAULT_LIST_BORDER = Border.of(0);
    public static final ScrollerSprites DEFAULT_SCROLLER_SPRITE = ScrollerSprites.of(class_2960.method_60656((String)"widget/scroller"));
    public static final class_2960 DEFAULT_SCROLL_BAR_BACKGROUND = class_2960.method_60656((String)"widget/scroller_background");
    public static final Padding DEFAULT_SCROLL_BAR_PADDING = Padding.of(0);
    public static final Border DEFAULT_SCROLL_BAR_BORDER = Border.of(0);
    public static final Padding DEFAULT_SCROLL_BAR_CONTAINER_PADDING = Padding.of(0);
    public static final int DEFAULT_SCROLL_BAR_SPACING = 4;
    public static final int DEFAULT_SCROLLER_WIDTH = 6;
    public static final int DEFAULT_MIN_SCROLLER_HEIGHT = 32;
    public static final int DEFAULT_ITEM_HEIGHT = 20;
    public static final int DEFAULT_ITEM_SPACING = 0;
    @Nullable
    protected ItemSprites itemSprites;
    protected int itemSpacing;
    @Nullable
    protected class_2960 listBackground;
    protected Border listBorder = Border.ZERO;
    protected Padding listPadding = Padding.ZERO;
    protected boolean scrollBarAlwaysVisible;
    protected int scrollBarSpacing;
    protected ScrollBarStyle scrollBarStyle = ScrollBarStyle.DETACHED;
    @Nullable
    protected ScrollerSprites scrollerSprites;
    protected int scrollerWidth = 6;
    protected int minScrollerHeight = 32;
    @Nullable
    protected class_2960 scrollBarBackground;
    protected Border scrollBarBorder = Border.ZERO;
    protected Padding scrollBarPadding = Padding.ZERO;
    protected Padding scrollBarContainerPadding = Padding.ZERO;
    @Nullable
    protected Supplier<Boolean> activeSupplier;
    protected boolean scrolling;
    protected boolean ignoreReposition;

    protected FrameworkSelectionList(int width, int height, int x, int y, int itemHeight) {
        super(class_310.method_1551(), width, height, y, itemHeight);
    }

    private FrameworkSelectionList(int x, int y, int width, int height, int itemHeight, @Nullable ItemSprites itemSprites, int itemSpacing, @Nullable class_2960 listBackground, Border listBorder, Padding listPadding, boolean scrollBarAlwaysVisible, int scrollBarSpacing, ScrollBarStyle scrollBarStyle, @Nullable ScrollerSprites scrollerSprites, int scrollerWidth, int minScrollerHeight, @Nullable class_2960 scrollBarBackground, Border scrollBarBorder, Padding scrollBarPadding, Padding scrollBarContainerPadding, @Nullable Supplier<Boolean> activeSupplier, @Nullable Consumer<Consumer<Item>> itemsSupplier) {
        this(width, height, x, y, itemHeight);
        this.itemSprites = itemSprites;
        this.itemSpacing = itemSpacing;
        this.listBackground = listBackground;
        this.listBorder = listBorder;
        this.listPadding = listPadding;
        this.scrollBarAlwaysVisible = scrollBarAlwaysVisible;
        this.scrollBarSpacing = scrollBarSpacing;
        this.scrollBarStyle = scrollBarStyle;
        this.scrollerSprites = scrollerSprites;
        this.scrollerWidth = scrollerWidth;
        this.minScrollerHeight = minScrollerHeight;
        this.scrollBarBackground = scrollBarBackground;
        this.scrollBarBorder = scrollBarBorder;
        this.scrollBarPadding = scrollBarPadding;
        this.scrollBarContainerPadding = scrollBarContainerPadding;
        this.activeSupplier = activeSupplier;
        if (itemsSupplier != null) {
            itemsSupplier.accept(this::addItem);
        }
        this.method_48229(x, y);
    }

    public void method_48229(int x, int y) {
        this.ignoreReposition = true;
        super.method_48229(x, y);
        this.ignoreReposition = false;
        this.repositionItems();
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.repositionItems();
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.repositionItems();
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.method_46427() && mouseY <= (double)(this.method_46427() + this.method_25364()) && mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.method_25368());
    }

    public int method_25322() {
        return this.method_31383() - this.method_25342();
    }

    public int method_25342() {
        return this.method_46426() + this.listBorder.left() + this.listPadding.left();
    }

    public int method_31383() {
        if (this.method_44390() > 0 || this.scrollBarAlwaysVisible) {
            int scrollBarArea = switch (this.scrollBarStyle.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.listPadding.right() + this.listBorder.right() + this.scrollBarSpacing + this.scrollBarContainerPadding.left() + this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right();
                case 1 -> this.scrollBarSpacing + this.scrollBarContainerPadding.left() + this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right() + this.listPadding.right() + this.listBorder.right();
            };
            return this.method_46426() + this.method_25368() - scrollBarArea;
        }
        return this.method_46426() + this.method_25368() - this.listPadding.right() - this.listBorder.right();
    }

    public int getFirstItemY() {
        return this.method_46427() + this.listBorder.top() + this.listPadding.top();
    }

    public void repositionItems() {
        if (this.ignoreReposition) {
            return;
        }
        int nextY = this.getFirstItemY() - (int)this.method_44387();
        for (Item item : this.method_25396()) {
            item.method_46419(nextY);
            nextY += item.method_25364();
            nextY += this.itemSpacing;
            item.method_46421(this.method_25342());
            item.method_73381(this.method_25322());
        }
    }

    public int method_73378() {
        int nextY = this.getFirstItemY() - (int)this.method_44387();
        for (Item item : this.method_25396()) {
            nextY += item.method_25364();
            nextY += this.itemSpacing;
        }
        return nextY;
    }

    protected int method_65507() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right();
            case 1 -> this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right() + this.scrollBarContainerPadding.right() + this.listPadding.right() + this.listBorder.right();
        };
        return this.method_46426() + this.method_25368() - offset;
    }

    protected int getScrollbarHeight() {
        int scrollAreaHeight = this.getScrollAreaHeight();
        int scrollBarHeight = (int)((float)class_3532.method_34954((int)scrollAreaHeight) / (float)this.method_44395());
        return class_3532.method_15340((int)scrollBarHeight, (int)this.minScrollerHeight, (int)scrollAreaHeight);
    }

    protected int getScrollAreaHeight() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top() + this.scrollBarPadding.bottom() + this.scrollBarBorder.bottom() + this.scrollBarContainerPadding.bottom();
            case 1 -> this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top() + this.scrollBarPadding.bottom() + this.scrollBarBorder.bottom() + this.scrollBarContainerPadding.bottom() + this.listPadding.bottom() + this.listBorder.bottom();
        };
        return this.method_25364() - offset;
    }

    protected int getScrollAreaTop() {
        int offset = switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top();
            case 1 -> this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top() + this.scrollBarBorder.top() + this.scrollBarPadding.top();
        };
        return this.method_46427() + offset;
    }

    public int method_44390() {
        return Math.max(0, this.method_44395() - this.field_22759 + this.listBorder.top() + this.listPadding.top() + this.listPadding.bottom() + this.listBorder.bottom());
    }

    protected int method_44395() {
        int height = 0;
        for (Item item : this.method_25396()) {
            height += item.method_25364();
            height += this.itemSpacing;
        }
        return Math.max(0, height - this.itemSpacing);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.activeSupplier != null) {
            this.field_22763 = this.activeSupplier.get();
        }
        this.renderListBackground(graphics, mouseX, mouseY, partialTick);
        this.method_25311(graphics, mouseX, mouseY, partialTick);
        this.method_44396(graphics, mouseX, mouseY);
    }

    protected int getListBackgroundWidth() {
        return switch (this.scrollBarStyle.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.listBorder.left() + this.listPadding.left() + this.method_25322() + this.listPadding.right() + this.listBorder.right();
            case 1 -> this.method_25368();
        };
    }

    protected int getListBackgroundHeight() {
        return this.method_25364();
    }

    protected void renderListBackground(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.listBackground != null) {
            graphics.method_52706(class_10799.field_56883, this.listBackground, this.method_46426(), this.method_46427(), this.getListBackgroundWidth(), this.getListBackgroundHeight());
        }
    }

    protected void method_44396(class_332 graphics, int mouseX, int mouseY) {
        int maxScroll = this.method_44390();
        if (maxScroll > 0 || this.scrollBarAlwaysVisible) {
            if (this.scrollBarBackground != null) {
                int scrollBarTop = this.method_46427();
                if (this.scrollBarStyle == ScrollBarStyle.MERGED) {
                    scrollBarTop += this.listBorder.top() + this.listPadding.top() + this.scrollBarContainerPadding.top();
                }
                int scrollBarLeft = this.method_65507() - this.scrollBarPadding.left() - this.scrollBarBorder.left();
                int scrollBarAreaWidth = this.scrollBarBorder.left() + this.scrollBarPadding.left() + this.scrollerWidth + this.scrollBarPadding.right() + this.scrollBarBorder.right();
                int scrollBarAreaHeight = this.method_25364() - this.scrollBarContainerPadding.top() - this.scrollBarContainerPadding.bottom();
                if (this.scrollBarStyle == ScrollBarStyle.MERGED) {
                    scrollBarAreaHeight -= this.listBorder.top() + this.listPadding.top() + this.listPadding.bottom() + this.listBorder.bottom();
                }
                graphics.method_52706(class_10799.field_56883, this.scrollBarBackground, scrollBarLeft, scrollBarTop, scrollBarAreaWidth, scrollBarAreaHeight);
            }
            boolean scrollBarEnabled = maxScroll > 0 && this.method_37303();
            int scrollBarStart = this.method_65507();
            int scrollBarEnd = scrollBarStart + this.scrollerWidth;
            int scrollBarHeight = this.getScrollbarHeight();
            int scrollBarTop = (int)((double)this.getScrollAreaTop() + (double)(this.getScrollAreaHeight() - this.getScrollbarHeight()) * (this.method_44387() / (double)Math.max(maxScroll, 1)));
            boolean scrollBarHovered = ClientUtils.isPointInArea(mouseX, mouseY, scrollBarStart, scrollBarTop, this.scrollerWidth, scrollBarHeight);
            if (this.scrollerSprites != null) {
                class_2960 sprite = this.scrollerSprites.get(scrollBarEnabled, scrollBarHovered, this.scrolling);
                if (sprite != null) {
                    int alpha = class_9848.method_61317((float)(this.field_22763 ? 1.0f : 0.5f));
                    graphics.method_52707(class_10799.field_56883, sprite, scrollBarStart, scrollBarTop, scrollBarEnd - scrollBarStart, scrollBarHeight, alpha);
                }
            } else {
                int scrollBarColour = scrollBarHovered ? -13423059 : -12107714;
                graphics.method_25294(scrollBarStart, scrollBarTop, scrollBarEnd, scrollBarTop + scrollBarHeight, scrollBarColour);
            }
        }
    }

    protected void method_25311(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_44379(this.method_25342(), this.method_46427() + this.listBorder.top(), this.method_31383(), this.method_46427() + this.method_25364() - this.listBorder.bottom());
        for (Item item : this.method_25396()) {
            if (item.method_46427() + item.method_25364() < this.method_46427() || item.method_46427() > this.method_55443()) continue;
            this.renderItem(graphics, mouseX, mouseY, partialTick, item);
        }
        graphics.method_44380();
    }

    protected void renderItem(class_332 graphics, int mouseX, int mouseY, float partialTick, Item item) {
        boolean hovered = !this.scrolling && item.method_25405(mouseX, mouseY) && this.method_25405(mouseX, mouseY);
        boolean selected = this.getSelected() == item;
        item.setHovered(hovered);
        item.renderBackground(this.itemSprites, graphics, mouseX, mouseY, hovered, selected);
        item.method_25343(graphics, mouseX, mouseY, selected, partialTick);
    }

    protected void renderSelection(class_332 graphics, Item item, int outlineColour) {
        super.method_44398(graphics, (class_350.class_351)item, outlineColour);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (!this.method_37303() || !this.method_25351(event.comp_4800())) {
            return false;
        }
        this.method_65505(event);
        if (!this.method_25405(event.comp_4798(), event.comp_4799())) {
            return false;
        }
        Item item = (Item)this.method_25308(event.comp_4798(), event.comp_4799());
        if (item != null && item.method_25402(event, doubleClick)) {
            Item focused = (Item)this.method_25336();
            if (focused != item && focused instanceof class_4069) {
                class_4069 handler = (class_4069)focused;
                handler.method_25395(null);
            }
            this.method_25395((class_364)item);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25406(class_11909 event) {
        this.scrolling = false;
        return super.method_25406(event);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        if (event.method_74245() == 0) {
            if (this.method_25336() != null && this.method_25397() && ((Item)this.method_25336()).method_25403(event, deltaX, deltaY)) {
                return true;
            }
            if (this.scrolling) {
                double unitsPerScroll = (double)this.method_44390() / (double)Math.max(1, this.getScrollAreaHeight() - this.getScrollbarHeight());
                this.method_44382(this.method_44387() + deltaY * unitsPerScroll);
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.field_22763 && super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public void addItem(Item item) {
        super.method_25321((class_350.class_351)item);
    }

    public void removeItem(int index) {
        List children = this.method_25396();
        if (index >= 0 && index < children.size()) {
            this.method_25330((class_350.class_351)((Item)((Object)children.get(index))));
        }
    }

    public void removeItem(Item item) {
        super.method_25330((class_350.class_351)item);
    }

    public void removeIf(Predicate<? super Item> predicate) {
        List<? super Item> remove = this.method_25396().stream().filter(predicate).toList();
        if (!remove.isEmpty()) {
            this.ignoreReposition = true;
            this.method_73373(remove);
            this.ignoreReposition = false;
            this.repositionItems();
        }
    }

    public boolean method_65505(class_11909 event) {
        this.scrolling = this.method_44392() && event.method_74245() == 0 && ClientUtils.isPointInArea((int)event.comp_4798(), (int)event.comp_4799(), this.method_65507(), this.getScrollAreaTop(), this.scrollerWidth, this.getScrollAreaHeight());
        ClientServices.CLIENT.setScrollingState((class_350<?>)this, this.scrolling);
        return this.scrolling;
    }

    @Nullable
    public Item getSelected() {
        Item selected = (Item)super.method_25334();
        if (selected != null && selected.isSelectable()) {
            return selected;
        }
        return null;
    }

    public void setSelected(@Nullable Item item) {
        if (item == null || item.isSelectable()) {
            super.method_25313((class_350.class_351)item);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ScrollBarStyle {
        DETACHED,
        MERGED;

    }

    public static final class ItemSprites {
        private final ImmutableMap<Integer, class_2960> map;

        private ItemSprites(@Nullable class_2960 enabled, @Nullable class_2960 disabled, @Nullable class_2960 enabledHovered, @Nullable class_2960 disabledHovered, @Nullable class_2960 enabledSelected, @Nullable class_2960 disabledSelected, @Nullable class_2960 enabledHoveredSelected, @Nullable class_2960 disabledHoveredSelected) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (disabled != null) {
                builder.put((Object)this.calculateKey(false, false, false), (Object)disabled);
            }
            if (enabled != null) {
                builder.put((Object)this.calculateKey(true, false, false), (Object)enabled);
            }
            if (disabledHovered != null) {
                builder.put((Object)this.calculateKey(false, true, false), (Object)disabledHovered);
            }
            if (enabledHovered != null) {
                builder.put((Object)this.calculateKey(true, true, false), (Object)enabledHovered);
            }
            if (disabledSelected != null) {
                builder.put((Object)this.calculateKey(false, false, true), (Object)disabledSelected);
            }
            if (enabledSelected != null) {
                builder.put((Object)this.calculateKey(true, false, true), (Object)enabledSelected);
            }
            if (disabledHoveredSelected != null) {
                builder.put((Object)this.calculateKey(false, true, true), (Object)disabledHoveredSelected);
            }
            if (enabledHoveredSelected != null) {
                builder.put((Object)this.calculateKey(true, true, true), (Object)enabledHoveredSelected);
            }
            this.map = builder.build();
        }

        private int calculateKey(boolean enabled, boolean hovered, boolean selected) {
            int key = 0;
            if (enabled) {
                key |= 1;
            }
            if (hovered) {
                key |= 2;
            }
            if (selected) {
                key |= 4;
            }
            return key;
        }

        @Nullable
        public class_2960 getSprite(boolean enabled, boolean hovered, boolean selected) {
            return (class_2960)this.map.get((Object)this.calculateKey(enabled, hovered, selected));
        }

        public static ItemSprites of(@Nullable class_2960 all) {
            return new ItemSprites(all, all, all, all, all, all, all, all);
        }

        public static ItemSprites of(@Nullable class_2960 enabled, @Nullable class_2960 disabled, @Nullable class_2960 enabledSelected) {
            return new ItemSprites(enabled, disabled, enabled, disabled, enabledSelected, disabled, enabledSelected, disabled);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            @Nullable
            private class_2960 enabled;
            @Nullable
            private class_2960 disabled;
            @Nullable
            private class_2960 enabledHovered;
            @Nullable
            private class_2960 disabledHovered;
            @Nullable
            private class_2960 enabledSelected;
            @Nullable
            private class_2960 disabledSelected;
            @Nullable
            private class_2960 enabledHoveredSelected;
            @Nullable
            private class_2960 disabledHoveredSelected;

            public ItemSprites build() {
                return new ItemSprites(this.enabled, this.disabled, this.enabledHovered, this.disabledHovered, this.enabledSelected, this.disabledSelected, this.enabledHoveredSelected, this.disabledHoveredSelected);
            }

            public Builder setEnabled(@Nullable class_2960 texture) {
                this.enabled = texture;
                return this;
            }

            public Builder setDisabled(@Nullable class_2960 texture) {
                this.disabled = texture;
                return this;
            }

            public Builder setEnabledHovered(@Nullable class_2960 texture) {
                this.enabledHovered = texture;
                return this;
            }

            public Builder setDisabledHovered(@Nullable class_2960 texture) {
                this.disabledHovered = texture;
                return this;
            }

            public Builder setEnabledSelected(@Nullable class_2960 texture) {
                this.enabledSelected = texture;
                return this;
            }

            public Builder setDisabledSelected(@Nullable class_2960 texture) {
                this.disabledSelected = texture;
                return this;
            }

            public Builder setEnabledHoveredSelected(@Nullable class_2960 texture) {
                this.enabledHoveredSelected = texture;
                return this;
            }

            public Builder setDisabledHoveredSelected(@Nullable class_2960 texture) {
                this.disabledHoveredSelected = texture;
                return this;
            }
        }
    }

    public static final class ScrollerSprites {
        private final class_2960 enabled;
        @Nullable
        private final class_2960 disabled;
        private final class_2960 hovered;
        private final class_2960 dragging;

        private ScrollerSprites(class_2960 enabled, @Nullable class_2960 disabled, class_2960 hovered, class_2960 dragging) {
            this.enabled = enabled;
            this.disabled = disabled;
            this.hovered = hovered;
            this.dragging = dragging;
        }

        public static ScrollerSprites of(class_2960 all) {
            return new ScrollerSprites(all, all, all, all);
        }

        public static ScrollerSprites of(class_2960 enabled, class_2960 disabled, class_2960 hovered) {
            return new ScrollerSprites(enabled, disabled, hovered, hovered);
        }

        public static ScrollerSprites of(class_2960 enabled, class_2960 disabled, class_2960 hovered, class_2960 dragging) {
            return new ScrollerSprites(enabled, disabled, hovered, dragging);
        }

        @Nullable
        public class_2960 get(boolean enabled, boolean hovered, boolean dragging) {
            if (!enabled) {
                return this.disabled;
            }
            if (hovered) {
                return this.hovered;
            }
            if (dragging) {
                return this.dragging;
            }
            return this.enabled;
        }
    }

    public static abstract class Item
    extends class_4280.class_4281<Item> {
        private boolean hovered;

        protected abstract void renderContent(class_332 var1, int var2, int var3, boolean var4, boolean var5, float var6);

        private void setHovered(boolean hovered) {
            this.hovered = hovered;
        }

        public boolean isSelectable() {
            return true;
        }

        public int method_73380() {
            return this.method_46426();
        }

        public int method_73382() {
            return this.method_46427();
        }

        public int method_73384() {
            return this.method_25364();
        }

        public int method_73387() {
            return this.method_25368();
        }

        public class_2561 method_37006() {
            return class_5244.field_39003;
        }

        public final void method_25343(class_332 graphics, int mouseX, int mouseY, boolean selected, float partialTick) {
            this.renderContent(graphics, mouseX, mouseY, this.hovered, selected, partialTick);
        }

        protected void renderBackground(@Nullable ItemSprites sprites, class_332 graphics, int mouseX, int mouseY, boolean hovered, boolean selected) {
            class_2960 sprite;
            if (sprites != null && (sprite = sprites.getSprite(true, hovered, selected)) != null) {
                graphics.method_52706(class_10799.field_56883, sprite, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            }
        }
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 100;
        private int height = 100;
        private int itemHeight = 20;
        @Nullable
        private ItemSprites itemSprites = DEFAULT_ITEM_SPRITE;
        private int itemSpacing = 0;
        @Nullable
        private class_2960 listBackground = DEFAULT_BACKGROUND;
        private Border listBorder = DEFAULT_LIST_BORDER;
        private Padding listPadding = DEFAULT_LIST_PADDING;
        private boolean scrollBarAlwaysVisible;
        private int scrollBarSpacing = 4;
        private ScrollBarStyle scrollBarStyle = ScrollBarStyle.DETACHED;
        @Nullable
        private ScrollerSprites scrollerSprites = DEFAULT_SCROLLER_SPRITE;
        private int scrollerWidth = 6;
        private int minScrollerHeight = 32;
        @Nullable
        private class_2960 scrollBarBackground = DEFAULT_SCROLL_BAR_BACKGROUND;
        private Border scrollBarBorder = DEFAULT_SCROLL_BAR_BORDER;
        private Padding scrollBarPadding = DEFAULT_SCROLL_BAR_PADDING;
        private Padding scrollBarContainerPadding = DEFAULT_SCROLL_BAR_CONTAINER_PADDING;
        @Nullable
        private Supplier<Boolean> activeSupplier;
        @Nullable
        private Consumer<Consumer<Item>> itemsSupplier;

        private Builder() {
        }

        public FrameworkSelectionList build() {
            return new FrameworkSelectionList(this.x, this.y, this.width, this.height, this.itemHeight, this.itemSprites, this.itemSpacing, this.listBackground, this.listBorder, this.listPadding, this.scrollBarAlwaysVisible, this.scrollBarSpacing, this.scrollBarStyle, this.scrollerSprites, this.scrollerWidth, this.minScrollerHeight, this.scrollBarBackground, this.scrollBarBorder, this.scrollBarPadding, this.scrollBarContainerPadding, this.activeSupplier, this.itemsSupplier);
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setItemHeight(int height) {
            this.itemHeight = height;
            return this;
        }

        public Builder setItemSprites(@Nullable ItemSprites sprites) {
            this.itemSprites = sprites;
            return this;
        }

        public Builder noItemSprites() {
            this.itemSprites = null;
            return this;
        }

        public Builder setItemSpacing(int spacing) {
            this.itemSpacing = spacing;
            return this;
        }

        public Builder setListBackground(@Nullable class_2960 texture) {
            this.listBackground = texture;
            return this;
        }

        public Builder noListBackground() {
            this.listBackground = null;
            return this;
        }

        public Builder setListBorder(Border border) {
            this.listBorder = border;
            return this;
        }

        public Builder setListPadding(Padding padding) {
            this.listPadding = padding;
            return this;
        }

        public Builder setScrollBarAlwaysVisible(boolean alwaysVisible) {
            this.scrollBarAlwaysVisible = alwaysVisible;
            return this;
        }

        public Builder setScrollBarSpacing(int spacing) {
            this.scrollBarSpacing = spacing;
            return this;
        }

        public Builder setScrollBarStyle(ScrollBarStyle style) {
            this.scrollBarStyle = style;
            return this;
        }

        public Builder setScrollerSprites(@Nullable ScrollerSprites sprites) {
            this.scrollerSprites = sprites;
            return this;
        }

        public Builder setScrollerWidth(int width) {
            this.scrollerWidth = width;
            return this;
        }

        public Builder setMinScrollerHeight(int minHeight) {
            this.minScrollerHeight = minHeight;
            return this;
        }

        public Builder setScrollBarBackground(@Nullable class_2960 texture) {
            this.scrollBarBackground = texture;
            return this;
        }

        public Builder setScrollBarBorder(Border border) {
            this.scrollBarBorder = border;
            return this;
        }

        public Builder setScrollBarPadding(Padding padding) {
            this.scrollBarPadding = padding;
            return this;
        }

        public Builder setScrollBarContainerPadding(Padding padding) {
            this.scrollBarContainerPadding = padding;
            return this;
        }

        public Builder setDependent(Supplier<Boolean> active) {
            this.activeSupplier = active;
            return this;
        }

        public Builder setInitialItems(Consumer<Consumer<Item>> items) {
            this.itemsSupplier = items;
            return this;
        }
    }
}

