/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.mrcrayfish.framework.api.client.screen.widget.element.Icon;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Border;
import com.mrcrayfish.framework.api.client.screen.widget.layout.Padding;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8021;
import net.minecraft.class_8666;
import net.minecraft.class_8667;
import net.minecraft.class_9017;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public final class FrameworkEditBox
extends class_9017 {
    private static final class_8666 DEFAULT_SPRITES = new class_8666(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"));
    public static final Padding DEFAULT_PADDING = Padding.of(4, 0, 4, 0);
    public static final Border DEFAULT_BORDER = Border.of(1);
    private final class_8667 layout = class_8667.method_52742();
    @Nullable
    private final Icon icon;
    @Nullable
    private final CenteredSpriteWidget iconWidget;
    private final Border border;
    private final Padding padding;
    private final int spacing;
    @Nullable
    private final class_8666 background;
    @Nullable
    private final Supplier<Boolean> activeSupplier;
    private final class_342 editBox;
    private final boolean clearOnRightClick;

    private FrameworkEditBox(int x, int y, int width, int height, Function<FrameworkEditBox, Icon> icon, Padding padding, int spacing, @Nullable class_8666 background, Border border, String text, @Nullable String suggestion, @Nullable class_2561 hint, @Nullable Consumer<String> callback, @Nullable Predicate<String> valueFilter, @Nullable class_342.class_11734 textFormatter, @Nullable Supplier<Boolean> activeSupplier, @Nullable Integer maxTextLength, boolean clearOnRightClick, @Nullable Integer iconWidthOverride) {
        super(x, y, width, height, class_5244.field_39003);
        this.icon = icon.apply(this);
        this.padding = padding;
        this.spacing = spacing;
        this.background = background;
        this.border = border;
        this.activeSupplier = activeSupplier;
        this.clearOnRightClick = clearOnRightClick;
        this.layout.method_52735(spacing);
        if (this.icon != null) {
            int iconWidth = iconWidthOverride != null ? iconWidthOverride.intValue() : this.icon.width();
            this.iconWidget = (CenteredSpriteWidget)this.layout.method_52738((class_8021)new CenteredSpriteWidget(iconWidth, 0, this.icon), layoutSettings -> layoutSettings.method_46471(border.top() + padding.top()).method_46475(border.bottom() + padding.bottom()).method_46469(padding.left() + border.left()));
        } else {
            this.iconWidget = null;
        }
        this.editBox = (class_342)this.layout.method_52738((class_8021)new Impl(this), layoutSettings -> {
            layoutSettings.method_46473(border.right() + padding.right()).method_46471(border.top() + padding.top()).method_46475(border.bottom() + padding.bottom());
            if (this.icon == null) {
                layoutSettings.method_46469(border.left() + padding.left());
            }
        });
        this.updateEditBoxWidth();
        if (valueFilter != null) {
            this.editBox.method_1890(valueFilter);
        }
        if (maxTextLength != null) {
            this.editBox.method_1880(maxTextLength.intValue());
        }
        this.editBox.method_1852(text);
        this.editBox.method_1887(suggestion);
        if (hint != null) {
            this.editBox.method_47404(hint);
        }
        if (callback != null) {
            this.editBox.method_1863(callback);
        }
        if (textFormatter != null) {
            this.editBox.method_73210(textFormatter);
        }
        this.method_55445(width, height);
    }

    private void updateEditBoxWidth() {
        if (this.iconWidget != null) {
            this.editBox.method_25358(this.method_25368() - (this.border.left() + this.padding.left() + this.iconWidget.method_25368() + this.spacing + this.padding.right() + this.border.right()));
        } else {
            this.editBox.method_25358(this.method_25368() - (this.border.left() + this.padding.left() + this.padding.right() + this.border.right()));
        }
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.layout.method_46421(x);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.layout.method_46419(y);
    }

    public void method_25358(int width) {
        super.method_25358(width);
        this.updateEditBoxWidth();
        this.layout.method_48222();
    }

    public void method_53533(int height) {
        super.method_53533(height);
        this.updateEditBoxWidth();
        int contentHeight = height - (this.border.top() + this.padding.top() + this.padding.bottom() + this.border.bottom());
        this.editBox.method_53533(contentHeight);
        if (this.iconWidget != null) {
            this.iconWidget.method_53533(contentHeight);
        }
        this.layout.method_48222();
    }

    public void method_55445(int width, int height) {
        this.method_25358(width);
        this.method_53533(height);
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.activeSupplier != null) {
            boolean active;
            this.field_22763 = active = this.activeSupplier.get().booleanValue();
            this.editBox.field_22763 = active;
        }
        if (this.background != null) {
            int alpha = class_9848.method_61317((float)(this.editBox.method_37303() ? 1.0f : 0.5f));
            class_2960 background = this.background.method_52729(this.editBox.method_37303(), this.editBox.method_25370());
            graphics.method_52707(class_10799.field_56883, background, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), alpha);
        }
        this.layout.method_48206(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTick));
    }

    protected void method_47399(class_6382 output) {
        this.editBox.method_37020(output);
    }

    public List<? extends class_364> method_25396() {
        return List.of(this.editBox);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        this.editBox.method_25365(focused);
    }

    public String getText() {
        return this.editBox.method_1882();
    }

    public class_342 getEditBox() {
        return this.editBox;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected int method_44395() {
        return this.field_22759;
    }

    protected double method_44393() {
        return 0.0;
    }

    private static final class CenteredSpriteWidget
    extends class_339 {
        private final Icon icon;

        public CenteredSpriteWidget(int width, int height, Icon icon) {
            super(0, 0, width, height, class_5244.field_39003);
            this.icon = icon;
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            int iconX = this.method_46426() + (this.method_25368() - this.icon.width()) / 2;
            int iconY = this.method_46427() + (this.method_25364() - this.icon.height()) / 2;
            this.icon.draw(graphics, iconX, iconY, class_9848.method_61317((float)1.0f), partialTick);
        }

        protected void method_47399(class_6382 output) {
        }
    }

    public static class Impl
    extends class_342 {
        private final FrameworkEditBox parent;

        private Impl(FrameworkEditBox parent) {
            super(class_310.method_1551().field_1772, 0, 0, class_5244.field_39003);
            this.method_1858(false);
            this.parent = parent;
        }

        public boolean method_1851() {
            return false;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= (double)this.parent.method_46426() && mouseY >= (double)this.parent.method_46427() && mouseX < (double)(this.parent.method_46426() + this.parent.method_25368()) && mouseY < (double)(this.parent.method_46427() + this.parent.method_25364());
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.parent.clearOnRightClick && this.method_37303() && event.method_74245() == 1 && this.method_25405(event.comp_4798(), event.comp_4799())) {
                this.method_1852("");
                return true;
            }
            return super.method_25402(event, doubleClick);
        }
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 100;
        private int height = 16;
        private Function<FrameworkEditBox, Icon> icon = editBox1 -> null;
        private Border border = DEFAULT_BORDER;
        private Padding padding = DEFAULT_PADDING;
        private int spacing = 4;
        @Nullable
        private class_8666 background = DEFAULT_SPRITES;
        private String text = "";
        @Nullable
        private String suggestion;
        @Nullable
        private Consumer<String> callback;
        @Nullable
        private Predicate<String> valueFilter;
        @Nullable
        private class_342.class_11734 textFormatter;
        @Nullable
        private class_2561 hint;
        @Nullable
        private Supplier<Boolean> active;
        @Nullable
        private Integer maxTextLength;
        private boolean clearOnRightClick = true;
        @Nullable
        private Integer iconWidthOverride;

        public FrameworkEditBox build() {
            return new FrameworkEditBox(this.x, this.y, this.width, this.height, this.icon, this.padding, this.spacing, this.background, this.border, this.text, this.suggestion, this.hint, this.callback, this.valueFilter, this.textFormatter, this.active, this.maxTextLength, this.clearOnRightClick, this.iconWidthOverride);
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setIcon(class_2960 sprite, int width, int height) {
            this.icon = editBox -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Supplier<class_2960> sprite, int width, int height) {
            this.icon = editBox -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Function<FrameworkEditBox, Supplier<class_2960>> sprite, int width, int height) {
            this.icon = editBox -> Icon.sprite((Supplier)sprite.apply((FrameworkEditBox)((Object)editBox)), width, height);
            return this;
        }

        public Builder setIcon(@Nullable Icon icon) {
            this.icon = editBox -> icon;
            return this;
        }

        public Builder setIcon(Function<FrameworkEditBox, Icon> icon) {
            this.icon = icon;
            return this;
        }

        public Builder setIconWidth(int width) {
            this.iconWidthOverride = width;
            return this;
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setPadding(int padding) {
            this.padding = Padding.of(padding, padding, padding, padding);
            return this;
        }

        public Builder setPadding(int left, int top, int right, int bottom) {
            this.padding = Padding.of(left, top, right, bottom);
            return this;
        }

        public Builder setPadding(Padding padding) {
            this.padding = padding;
            return this;
        }

        public Builder setBackground(@Nullable class_8666 background) {
            this.background = background;
            return this;
        }

        public Builder noBackground() {
            this.background = null;
            return this;
        }

        public Builder setBorder(int border) {
            this.border = Border.of(border);
            return this;
        }

        public Builder setBorder(int left, int top, int right, int bottom) {
            this.border = Border.of(left, top, right, bottom);
            return this;
        }

        public Builder setBorder(Border border) {
            this.border = border;
            return this;
        }

        public Builder setInitialText(String text) {
            this.text = text;
            return this;
        }

        public Builder setMaxTextLength(int maxTextLength) {
            this.maxTextLength = maxTextLength;
            return this;
        }

        public Builder setCallback(@Nullable Consumer<String> callback) {
            this.callback = callback;
            return this;
        }

        public Builder setValueFilter(@Nullable Predicate<String> valueFilter) {
            this.valueFilter = valueFilter;
            return this;
        }

        public Builder setTextFormatter(@Nullable class_342.class_11734 textFormatter) {
            this.textFormatter = textFormatter;
            return this;
        }

        public Builder setHint(@Nullable class_2561 hint) {
            this.hint = hint;
            return this;
        }

        public Builder setDependent(Supplier<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder setClearOnRightClick(boolean clearOnRightClick) {
            this.clearOnRightClick = clearOnRightClick;
            return this;
        }
    }
}

