/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.mrcrayfish.framework.api.client.screen.widget.element.Icon;
import com.mrcrayfish.framework.api.client.screen.widget.element.Label;
import com.mrcrayfish.framework.api.client.screen.widget.element.Sound;
import com.mrcrayfish.framework.api.client.screen.widget.input.Action;
import com.mrcrayfish.framework.api.client.screen.widget.input.MouseInput;
import java.time.Duration;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4264;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public final class FrameworkButton
extends class_4264 {
    public static final class_8666 DEFAULT_SPRITES = new class_8666(class_2960.method_60656((String)"widget/button"), class_2960.method_60656((String)"widget/button_disabled"), class_2960.method_60656((String)"widget/button_highlighted"));
    public static final int DEFAULT_TOOLTIP_DELAY = 350;
    public static final ContentRenderer<FrameworkButton> DEFAULT_CONTENT_RENDERER = new DefaultContentRenderer();
    private final Label label;
    @Nullable
    private final Icon icon;
    private final int spacing;
    @Nullable
    private final EnumMap<MouseInput, Action<FrameworkButton>> actions;
    @Nullable
    private final Supplier<class_8666> texture;
    @Nullable
    private final Supplier<Boolean> activeSupplier;
    @Nullable
    private final Function<FrameworkButton, class_7919> tooltip;
    private final int tooltipOptions;
    @Nullable
    private class_7919 currentTooltip;
    private boolean shiftWasDown;
    private boolean mouseIsHovering;
    @Nullable
    private final ContentRenderer<FrameworkButton> contentRenderer;

    private FrameworkButton(int x, int y, int width, int height, Label label, Function<FrameworkButton, Icon> icon, int spacing, @Nullable EnumMap<MouseInput, Action<FrameworkButton>> actions, @Nullable Supplier<class_8666> texture, @Nullable Supplier<Boolean> activeSupplier, @Nullable Function<FrameworkButton, class_7919> tooltip, int tooltipDelay, int tooltipOptions, @Nullable ContentRenderer<FrameworkButton> contentRenderer) {
        super(x, y, width, height, class_5244.field_39003);
        this.label = label;
        this.icon = icon.apply(this);
        this.spacing = spacing;
        this.actions = actions;
        this.texture = texture;
        this.activeSupplier = activeSupplier;
        this.tooltip = tooltip;
        this.tooltipOptions = tooltipOptions;
        this.contentRenderer = contentRenderer;
        this.updateActiveState();
        this.rebuildTooltip();
        this.method_47402(Duration.ofMillis(tooltipDelay));
    }

    public class_2561 method_25369() {
        return this.label.text();
    }

    public Label getLabel() {
        return this.label;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public class_8666 getTexture() {
        return this.texture != null ? this.texture.get() : null;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private void onAction(int button) {
        Action<FrameworkButton> action;
        Action<FrameworkButton> action2 = action = this.actions != null ? this.actions.get((Object)MouseInput.fromButton(button)) : null;
        if (action != null) {
            action.handler().accept(this);
            Sound sound = action.sound();
            if (sound != null) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound.value(), (float)sound.pitch(), (float)sound.volume()));
            }
        } else {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
        this.rebuildTooltip();
    }

    private void updateActiveState() {
        if (this.activeSupplier != null) {
            this.field_22763 = this.activeSupplier.get();
        }
    }

    public void rebuildTooltip() {
        if (this.tooltip != null) {
            this.currentTooltip = this.tooltip.apply(this);
        }
    }

    private void updateTooltip() {
        if ((this.tooltipOptions & 2) != 0 && !this.shiftWasDown && class_310.method_1551().method_74187() && this.method_49606()) {
            this.rebuildTooltip();
            this.shiftWasDown = true;
        }
        if (this.shiftWasDown && !class_310.method_1551().method_74187()) {
            this.rebuildTooltip();
            this.shiftWasDown = false;
        }
        if ((this.tooltipOptions & 4) != 0) {
            if (this.method_49606()) {
                if (!this.mouseIsHovering) {
                    this.rebuildTooltip();
                    this.mouseIsHovering = true;
                }
            } else {
                this.mouseIsHovering = false;
            }
        }
        if (!this.field_22763 && (this.tooltipOptions & 1) != 0) {
            this.method_47400(null);
        } else {
            this.method_47400(this.currentTooltip);
        }
    }

    public void method_25306(class_11907 input) {
        this.onAction(input.method_74228());
    }

    public void method_25354(class_1144 manager) {
    }

    protected void method_75752(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.updateActiveState();
        this.updateTooltip();
        if (this.contentRenderer != null) {
            this.contentRenderer.draw(this, graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void method_47399(class_6382 output) {
        this.method_37021(output);
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.method_37303() && this.method_25351(event.comp_4800()) && this.method_25405(event.comp_4798(), event.comp_4799())) {
            this.onAction(event.method_74245());
            return true;
        }
        return false;
    }

    protected boolean method_25351(class_11910 info) {
        return info.comp_4801() == 0 || this.actions != null && this.actions.containsKey((Object)MouseInput.fromButton(info.comp_4801()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface ContentRenderer<T> {
        public void draw(T var1, class_332 var2, int var3, int var4, float var5);
    }

    public static final class Builder {
        private int x;
        private int y;
        private int width = 20;
        private int height = 20;
        private Label label = Label.EMPTY;
        private Function<FrameworkButton, Icon> icon = btn -> null;
        private int spacing = 4;
        @Nullable
        private EnumMap<MouseInput, Action<FrameworkButton>> actions;
        @Nullable
        private Supplier<class_8666> texture = () -> DEFAULT_SPRITES;
        @Nullable
        private Supplier<Boolean> active;
        @Nullable
        private Function<FrameworkButton, class_7919> tooltip;
        private int tooltipDelay = 350;
        private int tooltipOptions;
        @Nullable
        private ContentRenderer<FrameworkButton> contentRenderer = DEFAULT_CONTENT_RENDERER;

        private Builder() {
        }

        public FrameworkButton build() {
            return new FrameworkButton(this.x, this.y, this.width, this.height, this.label, this.icon, this.spacing, this.actions, this.texture, this.active, this.tooltip, this.tooltipDelay, this.tooltipOptions, this.contentRenderer);
        }

        private EnumMap<MouseInput, Action<FrameworkButton>> actions() {
            if (this.actions == null) {
                this.actions = new EnumMap(MouseInput.class);
            }
            return this.actions;
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setLabel(class_2561 text) {
            this.label = Label.constant(text);
            return this;
        }

        public Builder setLabel(Supplier<class_2561> supplier) {
            this.label = Label.dynamic(supplier);
            return this;
        }

        public Builder setLabel(Label label) {
            this.label = label;
            return this;
        }

        public Builder setIcon(class_2960 sprite, int width, int height) {
            this.icon = btn -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Supplier<class_2960> sprite, int width, int height) {
            this.icon = btn -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Function<FrameworkButton, Supplier<class_2960>> sprite, int width, int height) {
            this.icon = btn -> Icon.sprite((Supplier)sprite.apply((FrameworkButton)((Object)btn)), width, height);
            return this;
        }

        public Builder setIcon(Icon icon) {
            this.icon = btn -> icon;
            return this;
        }

        public Builder setIcon(Function<FrameworkButton, Icon> icon) {
            this.icon = icon;
            return this;
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.LEFT_CLICK, Action.create(action));
            return this;
        }

        public Builder setPrimaryAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.LEFT_CLICK, Action.create(action));
            return this;
        }

        public Builder setPrimaryAction(Action<FrameworkButton> action) {
            this.actions().put(MouseInput.LEFT_CLICK, action);
            return this;
        }

        public Builder setSecondaryAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.RIGHT_CLICK, Action.create(action));
            return this;
        }

        public Builder setSecondaryAction(Action<FrameworkButton> action) {
            this.actions().put(MouseInput.RIGHT_CLICK, action);
            return this;
        }

        public Builder setTertiaryAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.MIDDLE_CLICK, Action.create(action));
            return this;
        }

        public Builder setTertiaryAction(Action<FrameworkButton> action) {
            this.actions().put(MouseInput.MIDDLE_CLICK, action);
            return this;
        }

        public Builder setAction(MouseInput input, Action<FrameworkButton> action) {
            this.actions().put(input, action);
            return this;
        }

        public Builder setTexture(class_8666 texture) {
            this.texture = () -> texture;
            return this;
        }

        public Builder setTexture(Supplier<class_8666> texture) {
            this.texture = texture;
            return this;
        }

        public Builder noTexture() {
            this.texture = null;
            return this;
        }

        public Builder setDependent(Supplier<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder setTooltip(class_7919 tooltip) {
            this.tooltip = btn -> tooltip;
            return this;
        }

        public Builder setTooltip(Function<FrameworkButton, class_7919> tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder setTooltipDelay(int delay) {
            this.tooltipDelay = delay;
            return this;
        }

        public Builder setTooltipOptions(int options) {
            this.tooltipOptions = options;
            return this;
        }

        public Builder setContentRenderer(@Nullable ContentRenderer<FrameworkButton> renderer) {
            this.contentRenderer = renderer;
            return this;
        }
    }

    public static class DefaultContentRenderer
    implements ContentRenderer<FrameworkButton> {
        @Override
        public void draw(FrameworkButton button, class_332 graphics, int mouseX, int mouseY, float partialTick) {
            Label label;
            int contentWidth;
            int contentHeight;
            class_8666 texture = button.getTexture();
            if (texture != null) {
                int alpha = class_9848.method_61317((float)(button.field_22763 ? 1.0f : 0.5f));
                graphics.method_52707(class_10799.field_56883, texture.method_52729(button.field_22763, button.method_25367() && button.field_22763), button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), alpha);
            }
            int n = contentHeight = (contentWidth = (label = button.getLabel()).width()) > 0 ? label.height() + 1 : 0;
            if (button.icon != null) {
                if (contentWidth > 0) {
                    contentWidth += button.spacing;
                }
                contentWidth += button.icon.width();
                contentHeight = Math.max(contentHeight, button.icon.height());
            }
            int contentLeft = button.method_46426() + (button.method_25368() - contentWidth) / 2;
            int contentTop = button.method_46427() + (button.method_25364() - contentHeight) / 2;
            int textX = contentLeft + (button.icon != null ? button.spacing + button.icon.width() : 0);
            int textY = contentTop + (contentHeight - label.height()) / 2 + 1;
            int textColour = button.field_22763 ? -1 : -10066330;
            boolean textShadow = button.field_22763;
            label.draw(graphics, textX, textY, textColour, textShadow);
            if (button.icon != null) {
                int iconX = contentLeft;
                int iconY = contentTop + (contentHeight - button.icon.height()) / 2;
                int alpha = class_9848.method_61317((float)(button.field_22763 ? 1.0f : 0.5f));
                button.icon.draw(graphics, iconX, iconY, alpha, partialTick);
            }
        }
    }

    public static class ToggleContentRenderer
    implements ContentRenderer<FrameworkButton> {
        private static final int TOGGLE_SIZE = 6;
        private static final class_8666 TOGGLE_SPRITES = new class_8666(class_2960.method_60655((String)"framework", (String)"widget/button/toggle_on"), class_2960.method_60655((String)"framework", (String)"widget/button/toggle_off"), class_2960.method_60655((String)"framework", (String)"widget/button/toggle_on"));
        private final Supplier<Boolean> state;

        public ToggleContentRenderer(Supplier<Boolean> state) {
            this.state = state;
        }

        @Override
        public void draw(FrameworkButton button, class_332 graphics, int mouseX, int mouseY, float partialTick) {
            class_8666 texture = button.getTexture();
            if (texture != null) {
                int alpha = class_9848.method_61317((float)(button.field_22763 ? 1.0f : 0.5f));
                graphics.method_52707(class_10799.field_56883, texture.method_52729(button.field_22763, button.method_25367() && button.field_22763), button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364(), alpha);
            }
            Label label = button.getLabel();
            int contentLeft = button.method_46426() + 6;
            int textX = contentLeft + (button.icon != null ? button.spacing + button.icon.width() : 0);
            int textY = button.method_46427() + (button.method_25364() - label.height()) / 2 + 1;
            int textColour = button.field_22763 ? -1 : -10066330;
            boolean textShadow = button.field_22763;
            label.draw(graphics, textX, textY, textColour, textShadow);
            if (button.icon != null) {
                int iconX = contentLeft;
                int iconY = button.method_46427() + (button.method_25364() - button.icon.height()) / 2;
                int alpha = class_9848.method_61317((float)(button.field_22763 ? 1.0f : 0.5f));
                button.icon.draw(graphics, iconX, iconY, alpha, partialTick);
            }
            int yOffset = (button.method_25364() - 6) / 2;
            int stateIconY = button.method_46427() + yOffset;
            int stateIconX = button.method_46426() + button.method_25368() - 6 - yOffset;
            int alpha = class_9848.method_61317((float)(button.field_22763 ? 1.0f : 0.5f));
            graphics.method_52707(class_10799.field_56883, TOGGLE_SPRITES.method_52729(this.state.get().booleanValue(), button.method_49606()), stateIconX, stateIconY, 6, 6, alpha);
        }
    }
}

