/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.import_export;

import java.io.File;
import journeymap.client.io.FileHandler;
import journeymap.client.log.ChatLog;
import journeymap.client.ui.component.screens.AbstractPopupScreen;
import journeymap.client.ui.component.widgets.ColoredStringWidget;
import journeymap.client.ui.dialog.import_export.ExportPopup;
import journeymap.client.ui.dialog.import_export.ImportFolderPopup;
import journeymap.client.ui.dialog.import_export.ImportZipPopup;
import journeymap.common.Journeymap;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class ImportExportPopup
extends AbstractPopupScreen {
    public ImportExportPopup() {
        super((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog"));
    }

    public void method_25426() {
        this.layout.method_52735(6);
        this.layout.method_52740().method_46467();
        this.layout.method_52738((class_8021)new ColoredStringWidget((class_2561)this.method_25440().method_27661().method_27692(class_124.field_1075).method_27692(class_124.field_1073), this.field_22793), class_7847::method_46467);
        class_8667 buttonLayout = class_8667.method_52741();
        buttonLayout.method_52735(10);
        buttonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_export"), button -> new ExportPopup().display()).method_46431());
        buttonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_import_zip"), button -> this.importZipFile()).method_46431());
        buttonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.importexport_dialog_import_folder"), button -> this.importFolder()).method_46431());
        buttonLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.close"), button -> this.method_25419()).method_46431());
        this.layout.method_52736((class_8021)buttonLayout);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        super.method_48640();
    }

    private void importZipFile() {
        String result;
        File jmWorldDir = FileHandler.getJMWorldDir(class_310.method_1551());
        if (jmWorldDir == null || !jmWorldDir.exists()) {
            ChatLog.announceError("No world is currently loaded. Please load a world first.");
            return;
        }
        File screenshotsDir = new File(FileHandler.getMinecraftDirectory(), "screenshots");
        if (!screenshotsDir.exists()) {
            screenshotsDir.mkdir();
        }
        String startingPath = screenshotsDir.getAbsolutePath() + File.separator;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer filterPatterns = stack.mallocPointer(1);
            filterPatterns.put(stack.UTF8((CharSequence)"*.zip"));
            filterPatterns.flip();
            result = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Select ZIP File to Import", (CharSequence)startingPath, (PointerBuffer)filterPatterns, (CharSequence)"ZIP Files", (boolean)false);
        }
        if (result != null) {
            File selectedFile = new File(result);
            if (!selectedFile.exists()) {
                ChatLog.announceError("Selected file does not exist.");
                return;
            }
            if (selectedFile.isFile() && selectedFile.getName().toLowerCase().endsWith(".zip")) {
                new ImportZipPopup(selectedFile).display();
            } else {
                ChatLog.announceError(class_2561.method_43471((String)"jm.common.importexport_dialog_no_zip").getString());
            }
        } else {
            Journeymap.getLogger().info("Import cancelled by user");
        }
    }

    private void importFolder() {
        File jmWorldDir = FileHandler.getJMWorldDir(class_310.method_1551());
        if (jmWorldDir == null || !jmWorldDir.exists()) {
            ChatLog.announceError("No world is currently loaded. Please load a world first.");
            return;
        }
        File startingDir = jmWorldDir;
        String startingPath = startingDir != null ? startingDir.getAbsolutePath() : null;
        String result = TinyFileDialogs.tinyfd_selectFolderDialog((CharSequence)"Select Folder to Import", (CharSequence)startingPath);
        if (result != null) {
            File selectedFolder = new File(result);
            if (!selectedFolder.exists() || !selectedFolder.isDirectory()) {
                ChatLog.announceError("Selected folder does not exist or is not a directory.");
                return;
            }
            new ImportFolderPopup(selectedFolder).display();
        } else {
            Journeymap.getLogger().info("Import cancelled by user");
        }
    }

    public static class DimensionFolder {
        final String name;
        final File folder;

        DimensionFolder(String name, File folder) {
            this.name = name;
            this.folder = folder;
        }
    }
}

