/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.impl;

import java.lang.reflect.Method;
import java.util.Optional;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.IModBlockHandler;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.common.util.ReflectionHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class TerraFirmaCraft
implements IModBlockHandler,
IBlockColorProxy {
    private static final int WATER_COLOR = 727360;
    private static final String TFC_COLORS_CLASS = "net.dries007.tfc.client.TFCColors";
    private final Optional<Method> getGrassColorMethod = ReflectionHelper.getStaticMethod("net.dries007.tfc.client.TFCColors", "getGrassColor", class_2338.class, Integer.TYPE);
    private final Optional<Method> getFoliageColorMethod;
    private final Optional<Method> getSeasonalFoliageColorMethod = ReflectionHelper.getStaticMethod("net.dries007.tfc.client.TFCColors", "getSeasonalFoliageColor", class_2338.class, Integer.TYPE);

    public TerraFirmaCraft() {
        this.getFoliageColorMethod = ReflectionHelper.getStaticMethod(TFC_COLORS_CLASS, "getFoliageColor", class_2338.class, Integer.TYPE);
    }

    @Override
    public void initialize(BlockMD blockMD) {
        blockMD.setBlockColorProxy(this);
        String name = blockMD.getBlockId().toLowerCase();
        if (name.contains("loose") || name.contains("looserock") || name.contains("loose_rock") || name.contains("rubble") || name.contains("vegetation") || name.contains("twig")) {
            blockMD.addFlags(BlockFlag.Ignore, BlockFlag.NoShadow, BlockFlag.NoTopo);
        } else if (name.contains("seagrass")) {
            blockMD.addFlags(BlockFlag.Plant);
        } else if (name.contains("grass") || name.contains("duff")) {
            blockMD.addFlags(BlockFlag.Grass);
        } else if (name.contains("water")) {
            blockMD.setAlpha(0.3f);
            blockMD.addFlags(BlockFlag.Water, BlockFlag.NoShadow);
        } else if (name.contains("leaves")) {
            blockMD.addFlags(BlockFlag.NoTopo, BlockFlag.Foliage);
        }
    }

    @Override
    @Nullable
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable class_2338 blockPos) {
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, class_2338 blockPos) {
        int color;
        Optional value;
        String name;
        block7: {
            name = blockMD.getBlockId().toLowerCase();
            if (blockMD.hasFlag(BlockFlag.Grass) && this.getGrassColorMethod.isPresent()) {
                if (name.contains("duff")) {
                    return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
                }
                value = ReflectionHelper.invokeStaticMethod(this.getGrassColorMethod.get(), blockPos, 1);
                if (value.isPresent()) {
                    return RGB.adjustBrightness((Integer)value.get(), 0.65f);
                }
            }
            color = -1;
            try {
                color = class_310.method_1551().method_1505().method_1691(blockMD.getBlockState(), (class_1937)chunkMD.getWorld(), blockPos);
            }
            catch (Exception e) {
                if (!blockMD.hasFlag(BlockFlag.Foliage) || !(value = ReflectionHelper.invokeStaticMethod(this.getSeasonalFoliageColorMethod.get(), blockPos, 1)).isPresent()) break block7;
                return RGB.adjustBrightness((Integer)value.get(), 0.5f);
            }
        }
        if (blockMD.hasFlag(BlockFlag.Foliage) && name.contains("leaves") && (value = ReflectionHelper.invokeStaticMethod(this.getFoliageColorMethod.get(), blockPos, 0)).isPresent()) {
            return RGB.adjustBrightness((Integer)value.get(), 0.5f);
        }
        if (color == -1) {
            color = blockMD.getBlock().method_26403().field_16011;
        }
        return color;
    }
}

