/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.ChatEventHandler;
import journeymap.client.event.handlers.ChunkMonitorHandler;
import journeymap.client.event.handlers.HudOverlayHandler;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.PlayerConnectHandler;
import journeymap.client.event.handlers.ScreenEventHandler;
import journeymap.client.event.handlers.StateTickHandler;
import journeymap.client.event.handlers.WaypointBeaconHandler;
import journeymap.client.event.handlers.WorldEventHandler;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7595;

public class FabricEventHandlerManager {
    private static FabricEventHandlerManager INSTANCE;
    private final WorldEventHandler worldEventHandler = new WorldEventHandler();
    private final WaypointBeaconHandler waypointBeaconHandler = new WaypointBeaconHandler();
    private final StateTickHandler stateTickHandler = new StateTickHandler();
    private final PlayerConnectHandler playerConnectHandler = new PlayerConnectHandler();
    private final HudOverlayHandler hudOverlayHandler = HudOverlayHandler.getInstance();
    private final ChunkMonitorHandler chunkMonitorHandler = ChunkMonitorHandler.getInstance();
    private final KeyEventHandler keyEventHandler = JourneymapClient.getInstance().getKeyEvents().getHandler();

    private FabricEventHandlerManager() {
        this.registerFabricEvents();
    }

    private void registerFabricEvents() {
        ClientTickEvents.END_CLIENT_TICK.register(listener -> this.stateTickHandler.onClientTick());
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (!class_310.method_1551().field_1705.method_53531().method_53536()) {
                this.hudOverlayHandler.onRenderOverlay(drawContext);
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenEvents.beforeRender((class_437)screen).register(this::onScreenRenderPreEvent));
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            ScreenMouseEvents.allowMouseClick((class_437)screen).register(this::onScreenMousePressedEvent);
            ScreenMouseEvents.beforeMouseRelease((class_437)screen).register(this::onScreenMouseReleasedEvent);
            ScreenEvents.remove((class_437)screen).register(this::onScreenClosedEvent);
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((keyScreen, event) -> {
                if (keyScreen != null) {
                    return !this.keyEventHandler.onGuiKeyboardEvent(keyScreen, event.comp_4795());
                }
                return true;
            });
            ScreenMouseEvents.afterMouseDrag((class_437)screen).register((mouseScreen, event, horizontalAmount, verticalAmount, consumed) -> this.onScreenMouseDraggedEvent(mouseScreen, event, horizontalAmount, verticalAmount));
            ScreenMouseEvents.afterMouseClick((class_437)screen).register((mouseScreen, event, consumed) -> {
                if (mouseScreen != null) {
                    return this.keyEventHandler.onMouseEvent(mouseScreen, event.comp_4800(), 1);
                }
                return true;
            });
        });
        ClientPlayConnectionEvents.DISCONNECT.register((phase, listener) -> this.playerConnectHandler.onDisconnect());
        ClientReceiveMessageEvents.ALLOW_CHAT.register((message, signedMessage, sender, params, receptionTimestamp) -> {
            class_2561 parsedMessage = ChatEventHandler.getInstance().onClientChatEventReceived(message);
            if (message != parsedMessage) {
                class_310.method_1551().field_1705.method_1743().method_44811(parsedMessage, signedMessage != null ? signedMessage.comp_1084() : null, signedMessage != null ? class_7595.field_39780.method_44741(signedMessage) : null);
                return false;
            }
            return true;
        });
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            class_2561 parsedMessage = ChatEventHandler.getInstance().onClientChatEventReceived(message);
            if (message != parsedMessage && parsedMessage != null) {
                class_310.method_1551().method_44714().method_44736(parsedMessage, false);
                return false;
            }
            return true;
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"jmc").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"sub", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ChatEventHandler.getInstance().onChatEvent(context.getInput());
            return 1;
        })).then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            ChatEventHandler.getInstance().onChatEvent(context.getInput());
            return 1;
        })))));
    }

    public static FabricEventHandlerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FabricEventHandlerManager();
        }
        return INSTANCE;
    }

    public void onWorldUnload(class_1936 world) {
        this.worldEventHandler.onUnload(world);
    }

    public void onRenderWorldLastEvent(class_332 graphics, class_4587 poseStack, boolean onlyBeacon) {
        this.waypointBeaconHandler.onRenderWaypoints(graphics, poseStack, onlyBeacon);
    }

    public void onScreenRenderPreEvent(class_437 screen, class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        ScreenEventHandler.getInstance().onScreenPreRender(screen, graphics, mouseX, mouseY);
    }

    public boolean onScreenMousePressedEvent(class_437 screen, class_11909 event) {
        return !ScreenEventHandler.getInstance().onScreenMousePressedEvent(screen, event);
    }

    public boolean onScreenMouseDraggedEvent(class_437 screen, class_11909 event, double dragX, double dragY) {
        return ScreenEventHandler.getInstance().onScreenMouseDraggedEvent(screen, event, dragX, dragY);
    }

    public boolean onScreenMouseReleasedEvent(class_437 screen, class_11909 event) {
        return ScreenEventHandler.getInstance().onScreenMouseReleasedEvent(screen, event);
    }

    public void onScreenClosedEvent(class_437 screen) {
        ScreenEventHandler.getInstance().onScreenClosedEvent(screen);
    }

    public void onPlayerConnect(class_310 minecraft) {
        this.playerConnectHandler.onConnect();
    }

    public void onBlockUpdate(class_1936 world, class_2338 pos) {
        this.chunkMonitorHandler.onBlockUpdate(world, pos);
    }

    public void onChunkUpdate(class_1936 world, class_1923 pos) {
        this.chunkMonitorHandler.onChunkUpdate(world, pos);
    }

    public void onChunkLoad(class_1936 world, class_2791 chunkAccess) {
        this.chunkMonitorHandler.onChunkLoad(world, chunkAccess);
    }

    public void keyPressEvent(class_11908 keyEvent) {
        this.keyEventHandler.onGameKeyboardEvent(keyEvent.comp_4795());
    }

    public void mouseEvent(class_11910 mouseButtonInfo, int action) {
        this.keyEventHandler.onMouseEvent(class_310.method_1551().field_1755, mouseButtonInfo, action);
    }
}

