/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.indicator;

import com.hyfata.najoan.koreanpatch.config.ColorOpacityConfig;
import com.hyfata.najoan.koreanpatch.config.ConfigManager;
import com.hyfata.najoan.koreanpatch.config.OutlineType;
import com.hyfata.najoan.koreanpatch.config.category.CategoryIndicator;
import com.hyfata.najoan.koreanpatch.config.category.indicator.outline.OutlineConfig;
import com.hyfata.najoan.koreanpatch.driver.InputManager;
import com.hyfata.najoan.koreanpatch.process.LangTypeManager;
import com.hyfata.najoan.koreanpatch.util.minecraft.RenderUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class IndicatorHandler {
    private static final class_310 client = class_310.method_1551();
    private static final float frame = 1.0f;
    private static final float margin = 1.0f;

    public static void showIndicator(class_332 guiGraphics, float x, float y) {
        CategoryIndicator categoryIndicator = ConfigManager.getInstance().getConfig().getCategoryIndicator();
        if (!categoryIndicator.isShowIndicator()) {
            return;
        }
        float width = LangTypeManager.getInstance().getCurrentTextWidth();
        Objects.requireNonNull(IndicatorHandler.client.field_1772);
        float height = 9.0f;
        IndicatorHandler.renderBox(guiGraphics, x, y, x + 1.0f + width + 2.0f, y + 1.0f + height + 2.0f, IndicatorHandler.getARGB(categoryIndicator.getOutlineSettings().getColorOpacitySettings()), IndicatorHandler.getARGB(categoryIndicator.getBackgroundSettings()));
        RenderUtil.drawCenteredText(guiGraphics, LangTypeManager.getInstance().getCurrentText(), x + 1.0f + width / 2.0f + 1.0f, y + 1.0f + height / 2.0f + 1.0f, IndicatorHandler.getARGB(categoryIndicator.getTextSettings()));
    }

    public static void showIndicator(class_332 guiGraphics, int x, int y) {
        IndicatorHandler.showIndicator(guiGraphics, (float)x, (float)y);
    }

    public static void showCenteredIndicator(class_332 guiGraphics, float x, float y) {
        IndicatorHandler.showIndicator(guiGraphics, x -= IndicatorHandler.getIndicatorWidth() / 2.0f, y -= IndicatorHandler.getIndicatorHeight() / 2.0f);
    }

    public static void showCenteredIndicator(class_332 guiGraphics, int x, int y) {
        IndicatorHandler.showCenteredIndicator(guiGraphics, (float)x, (float)y);
    }

    public static float getIndicatorWidth() {
        return 1.0f + (float)LangTypeManager.getInstance().getCurrentTextWidth() + 2.0f;
    }

    public static float getIndicatorHeight() {
        Objects.requireNonNull(IndicatorHandler.client.field_1772);
        return 1.0f + 9.0f + 2.0f;
    }

    private static int getARGB(ColorOpacityConfig colorOpacityConfig) {
        int outlineRGB = InputManager.getController().isFocused() ? colorOpacityConfig.getImeColor().getRGB() : (LangTypeManager.getInstance().isKorean() ? colorOpacityConfig.getKoreanColor().getRGB() : colorOpacityConfig.getEnColor().getRGB());
        int outlineOpacity = colorOpacityConfig.getOpacity() * 255 / 100;
        return (outlineOpacity & 0xFF) << 24 | outlineRGB & 0xFFFFFF;
    }

    private static void renderBox(class_332 guiGraphics, float x1, float y1, float x2, float y2, int frameColor, int backgroundColor) {
        OutlineConfig outlineConfig = ConfigManager.getInstance().getConfig().getCategoryIndicator().getOutlineSettings();
        float radius = 3.5f;
        float adjustment = 0.65f;
        float offset = outlineConfig.isShowOutline() ? 0.0f : 1.0f;
        RenderUtil.fill(guiGraphics, x1 + 1.0f - offset, y1 + 1.0f - offset, x2 - 1.0f + offset, y2 - 1.0f + offset, backgroundColor);
        if (outlineConfig.isShowOutline()) {
            OutlineType outlineType = outlineConfig.getOutlineType();
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RECTANGLE", "SUPERELLIPSE"}, (OutlineType)outlineType, n)) {
                case 0: {
                    radius = 0.0f;
                    adjustment = 0.0f;
                    break;
                }
                case 1: {
                    float radiusX = radius + 0.5f;
                    float radiusY = radius;
                    float exponent = 2.0f;
                    adjustment = 0.5f;
                    RenderUtil.drawVertexSuperellipseFrame(guiGraphics, x1 + radiusX, y1 + radius, radiusX, radiusY, exponent, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_LEFT);
                    RenderUtil.drawVertexSuperellipseFrame(guiGraphics, x2 - radiusX, y1 + radius, radiusX, radiusY, exponent, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_RIGHT);
                    RenderUtil.drawVertexSuperellipseFrame(guiGraphics, x1 + radiusX, y2 - radius, radiusX, radiusY, exponent, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_LEFT);
                    RenderUtil.drawVertexSuperellipseFrame(guiGraphics, x2 - radiusX, y2 - radius, radiusX, radiusY, exponent, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_RIGHT);
                    break;
                }
                default: {
                    RenderUtil.drawVertexCircleFrame(guiGraphics, x1 + radius, y1 + radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_LEFT);
                    RenderUtil.drawVertexCircleFrame(guiGraphics, x2 - radius, y1 + radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.TOP_RIGHT);
                    RenderUtil.drawVertexCircleFrame(guiGraphics, x1 + radius, y2 - radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_LEFT);
                    RenderUtil.drawVertexCircleFrame(guiGraphics, x2 - radius, y2 - radius, radius, frameColor, 1.0f, RenderUtil.VertexDirection.BOTTOM_RIGHT);
                }
            }
            RenderUtil.fill(guiGraphics, x1 + radius - adjustment, y1, x2 - radius + adjustment, y1 + 1.0f, frameColor);
            RenderUtil.fill(guiGraphics, x1 + radius - adjustment, y2, x2 - radius + adjustment, y2 - 1.0f, frameColor);
            RenderUtil.fill(guiGraphics, x1, y1 + radius - adjustment, x1 + 1.0f, y2 - radius + adjustment, frameColor);
            RenderUtil.fill(guiGraphics, x2, y1 + radius - adjustment, x2 - 1.0f, y2 - radius + adjustment, frameColor);
        }
    }
}

