/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.ConcurrentLinkedQueue;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.render.RenderQueue;
import net.minecraft.class_10366;
import net.minecraft.class_1044;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.opengl.GL11C;

public class RenderWrapper {
    private static final ConcurrentLinkedQueue<RenderQueue> renderQueue = Queues.newConcurrentLinkedQueue();
    public static final int GL_TEXTURE_2D = 3553;
    public static final int GL_NEAREST = 9728;
    public static final int GL_LINEAR = 9729;
    public static final int GL_TEXTURE_MAG_FILTER = 10240;
    public static final int GL_TEXTURE_MIN_FILTER = 10241;
    public static final int GL_NEAREST_MIPMAP_NEAREST = 9984;
    public static final int GL_NEAREST_MIPMAP_LINEAR = 9986;
    public static final int GL_LINEAR_MIPMAP_LINEAR = 9987;
    public static final int GL_TEXTURE_WRAP_S = 10242;
    public static final int GL_TEXTURE_WRAP_T = 10243;
    public static final int GL_REPEAT = 10497;
    public static final int GL_SRC_ALPHA = 770;
    public static final int GL_ONE_MINUS_SRC_ALPHA = 771;
    public static final int GL_ZERO = 0;
    public static final int GL_DEPTH_BUFFER_BIT = 256;
    public static final int GL_LEQUAL = 515;
    public static final int GL_GREATER = 516;
    public static final int GL_GEQUAL = 518;
    public static final int GL_NO_ERROR = 0;
    public static final int GL_VIEWPORT = 2978;
    public static final int UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL_UNSIGNED_BYTE = 5121;
    public static final int GL_BGRA = 32993;
    public static final int GL_RGBA = 6408;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_MIRRORED_REPEAT = 33648;
    public static final int GL_TEXTURE_LOD_BIAS = 34049;
    public static final boolean errorCheck = JourneymapClient.getInstance().getCoreProperties().glErrorChecking.get();

    public static void setColor4f(float red, float green, float blue, float alpha) {
        RenderWrapper.checkGLError("setColor4f");
    }

    public static void enableBlend() {
        GlStateManager._enableBlend();
        RenderWrapper.checkGLError("enableBlend");
    }

    public static void disableBlend() {
        GlStateManager._disableBlend();
        RenderWrapper.checkGLError("disableBlend");
    }

    public static void defaultBlendFunc() {
        RenderWrapper.blendFuncSeparate(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
        RenderWrapper.checkGLError("defaultBlendFunc");
    }

    public static void blendFuncSeparate(SourceFactor sourceFactor, DestFactor destFactor, SourceFactor sourceFactorAlpha, DestFactor destFactorAlpha) {
        GlStateManager._blendFuncSeparate((int)GlConst.toGl((SourceFactor)sourceFactor), (int)GlConst.toGl((DestFactor)destFactor), (int)GlConst.toGl((SourceFactor)sourceFactorAlpha), (int)GlConst.toGl((DestFactor)destFactorAlpha));
    }

    public static void enableDepthTest() {
        GlStateManager._enableDepthTest();
        RenderWrapper.checkGLError("enableDepthTest");
    }

    public static void disableDepthTest() {
        GlStateManager._disableDepthTest();
        RenderWrapper.checkGLError("disableDepthTest");
    }

    public static Matrix4f getProjectionMatrix() {
        return new Matrix4f();
    }

    public static int getError() {
        return GlStateManager._getError();
    }

    public static void texParameter(int target, int pname, int param) {
        GlStateManager._texParameter((int)target, (int)pname, (int)param);
        RenderWrapper.checkGLError("texParameter");
    }

    public static void blendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha) {
        GlStateManager._blendFuncSeparate((int)sfactorRGB, (int)dfactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
        RenderWrapper.checkGLError("blendFuncSeparate");
    }

    public static void blendFunc(int sfactor, int dfactor) {
        RenderWrapper.blendFuncSeparate(sfactor, dfactor, 1, 0);
        RenderWrapper.checkGLError("blendFunc");
    }

    public static void setShaderTexture(int index, class_1044 tex) {
        RenderWrapper.checkGLError("setShaderTexture");
    }

    public static void activeTexture(int texture) {
        GlStateManager._activeTexture((int)texture);
        RenderWrapper.checkGLError("activeTexture");
    }

    public static void bindTexture(int id) {
        GlStateManager._bindTexture((int)id);
        RenderWrapper.checkGLError("bindTexture");
    }

    public static void clear(int mask) {
        GlStateManager._clear((int)mask);
        RenderWrapper.checkGLError("clear");
    }

    public static void depthFunc(int func) {
        GlStateManager._depthFunc((int)func);
        RenderWrapper.checkGLError("depthFunc");
    }

    public static void setProjectionMatrix(GpuBufferSlice gpuBufferSlice, class_10366 sorting) {
        RenderSystem.setProjectionMatrix((GpuBufferSlice)gpuBufferSlice, (class_10366)sorting);
        RenderWrapper.checkGLError("setProjectionMatrix");
    }

    public static Matrix4fStack getModelViewStack() {
        Matrix4fStack stack = RenderSystem.getModelViewStack();
        RenderWrapper.checkGLError("getModelViewStack");
        return stack;
    }

    public static void texSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        GlStateManager._texSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
        RenderWrapper.checkGLError("texSubImage2D");
    }

    public static void clearDepth(int i) {
        GL11C.glClearDepth((double)i);
        RenderWrapper.checkGLError("clearDepth");
    }

    public static boolean checkGLError(String method) {
        if (errorCheck) {
            int err;
            boolean hasError = false;
            while ((err = RenderWrapper.getError()) != 0) {
                hasError = true;
                JMLogger.logOnce("GL Error in method: " + method + " ERROR: " + err);
            }
            return hasError;
        }
        return false;
    }

    public static void recordRenderQueue(RenderQueue call) {
        renderQueue.add(call);
    }

    public static void runRenderQueue() {
        while (!renderQueue.isEmpty()) {
            RenderQueue queue = renderQueue.poll();
            queue.execute();
        }
    }
}

