/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.log;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.api.services.WebMapService;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.apache.logging.log4j.Level;

public class ChatLog {
    static final List<class_5250> announcements = Collections.synchronizedList(new LinkedList());
    public static boolean enableAnnounceMod = false;
    private static boolean initialized = false;

    public static void queueAnnouncement(class_2561 chat) {
        class_5250 wrap = class_2561.method_43469((String)"jm.common.chat_announcement", (Object[])new Object[]{chat});
        announcements.add(wrap);
    }

    public static void announceURL(String message, String url) {
        class_5250 chat = Constants.getStringTextComponent(message);
        chat.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(url))));
        chat.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)Constants.getStringTextComponent(url))));
        ChatLog.queueAnnouncement((class_2561)chat);
    }

    public static void announceFile(String message, File file) {
        class_5250 chat = Constants.getStringTextComponent(message);
        try {
            String path = file.getCanonicalPath();
            chat.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(path)));
            chat.method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)Constants.getStringTextComponent(path))));
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't build ClickEvent for file: " + LogFormatter.toString(e));
        }
        ChatLog.queueAnnouncement((class_2561)chat);
    }

    public static void announceI18N(String key, Object ... parms) {
        String text = Constants.getString(key, parms);
        class_5250 chat = Constants.getStringTextComponent(text);
        ChatLog.queueAnnouncement((class_2561)chat);
    }

    public static void announceError(String text) {
        ErrorChat chat = new ErrorChat(text);
        ChatLog.queueAnnouncement(chat);
    }

    public static void announceActionBar(class_2561 message) {
        class_310.method_1551().field_1724.method_7353(message, true);
    }

    public static void announceWaypointRendering(boolean enable) {
        String key = JourneymapClient.getInstance().getKeyEvents().getHandler().kbToggleWaypointRendering.getTranslatedName().getString().toUpperCase();
        class_5250 enabled = enable ? class_2561.method_43471((String)"jm.common.action_bar.waypoint_rendering.toggle.enable") : class_2561.method_43471((String)"jm.common.action_bar.waypoint_rendering.toggle.disabled");
        class_5250 opposite = enable ? class_2561.method_43471((String)"jm.common.action_bar.waypoint_rendering.toggle.opposite.disabled") : class_2561.method_43471((String)"jm.common.action_bar.waypoint_rendering.toggle.opposite.enable");
        class_5250 message = class_2561.method_43469((String)"jm.common.action_bar.waypoint_rendering.message", (Object[])new Object[]{enabled, "\u00a7e" + key + "\u00a7f", opposite});
        ChatLog.announceActionBar((class_2561)message);
    }

    public static void showChatAnnouncements(class_310 mc) {
        if (!initialized) {
            enableAnnounceMod = JourneymapClient.getInstance().getCoreProperties().announceMod.get();
            ChatLog.announceMod(enableAnnounceMod);
            VersionCheck.getVersionIsCurrent();
            initialized = true;
        }
        while (!announcements.isEmpty()) {
            Level logLevel;
            class_5250 message = announcements.remove(0);
            if (message == null) continue;
            try {
                if (!JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue()) {
                    ChatLog.announceWaypointRendering(false);
                }
                mc.field_1705.method_1743().method_1812((class_2561)message);
            }
            catch (Exception e) {
                try {
                    Journeymap.getLogger().error("Could not display announcement in chat: " + LogFormatter.toString(e));
                }
                catch (Throwable throwable) {
                    Level logLevel2 = ((class_2588)message.method_10851()).method_11023()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                    Journeymap.getLogger().log(logLevel2, class_3544.method_15440((String)message.getString()));
                    throw throwable;
                }
                logLevel = ((class_2588)message.method_10851()).method_11023()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
                Journeymap.getLogger().log(logLevel, class_3544.method_15440((String)message.getString()));
                continue;
            }
            logLevel = ((class_2588)message.method_10851()).method_11023()[0] instanceof ErrorChat ? Level.ERROR : Level.INFO;
            Journeymap.getLogger().log(logLevel, class_3544.method_15440((String)message.getString()));
        }
    }

    public static void announceMod(boolean forced) {
        if (enableAnnounceMod || forced) {
            String keyName = JourneymapClient.getInstance().getKeyEvents().getHandler().kbFullscreenToggle.getTranslatedName().getString().toUpperCase();
            WebMapService webServer = JourneymapClient.getInstance().getWebMap();
            if (JourneymapClient.getInstance().getWebMapProperties().enabled.get().booleanValue() && webServer != null) {
                try {
                    String port = webServer.getPort() == 80 ? "" : ":" + webServer.getPort();
                    String message = Constants.getString("jm.common.webserver_and_mapgui_ready", keyName, port);
                    ChatLog.announceURL(message, "http://localhost" + port);
                }
                catch (Throwable t) {
                    Journeymap.getLogger().error("Couldn't check webserver: " + LogFormatter.toString(t));
                }
            } else {
                ChatLog.announceI18N("jm.common.mapgui_only_ready", keyName);
            }
            if (!JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
            }
            enableAnnounceMod = false;
        }
    }

    private static class ErrorChat
    implements class_2561 {
        String text;

        public ErrorChat(String text) {
            this.text = text;
        }

        public class_2583 method_10866() {
            return class_2583.field_24360;
        }

        public class_7417 method_10851() {
            return class_8828.method_54232((String)this.text);
        }

        public List<class_2561> method_10855() {
            return Lists.newArrayList();
        }

        public class_5481 method_30937() {
            return class_5481.field_26385;
        }
    }
}

